/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.base.integration.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.base.integration.jei.FiringRecipeCategory;
import svenhjol.charm.base.integration.jei.WoodCuttingRecipeCategory;
import svenhjol.charm.container.KilnContainer;
import svenhjol.charm.gui.KilnScreen;
import svenhjol.charm.module.DecreaseRepairCost;
import svenhjol.charm.module.Kilns;
import svenhjol.charm.module.NetheriteNuggets;
import svenhjol.charm.module.Woodcutters;

@JeiPlugin
public class CharmJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("charm", "charm");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        if (ModuleHandler.enabled(DecreaseRepairCost.class)) {
            this.registerReduceRepairCost(registration, factory);
        }
        if (ModuleHandler.enabled(Woodcutters.class)) {
            this.registerWoodCutterRecipes(registration, recipeManager);
        }
        if (ModuleHandler.enabled(Kilns.class)) {
            this.registerKilnRecipes(registration, recipeManager);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (ModuleHandler.enabled(Woodcutters.class)) {
            this.registerWoodCutterCategory(registration);
        }
        if (ModuleHandler.enabled(Kilns.class)) {
            this.registerKilnCategory(registration);
        }
    }

    private void registerWoodCutterCategory(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new WoodCuttingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    private void registerKilnCategory(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new FiringRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    private void registerWoodCutterRecipes(IRecipeRegistration registration, RecipeManager recipeManager) {
        registration.addRecipes((Collection)recipeManager.func_241447_a_(Woodcutters.RECIPE_TYPE), WoodCuttingRecipeCategory.UID);
    }

    private void registerKilnRecipes(IRecipeRegistration registration, RecipeManager recipeManager) {
        registration.addRecipes((Collection)recipeManager.func_241447_a_(Kilns.RECIPE_TYPE), FiringRecipeCategory.UID);
    }

    private void registerReduceRepairCost(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        ItemStack damagedPick = new ItemStack((IItemProvider)Items.field_151046_w);
        damagedPick.func_196085_b(1000);
        ItemStack repairedPick = damagedPick.func_77946_l();
        repairedPick.func_196085_b(1000);
        recipes.add(factory.createAnvilRecipe(damagedPick, Collections.singletonList(new ItemStack((IItemProvider)NetheriteNuggets.NETHERITE_NUGGET)), Collections.singletonList(repairedPick)));
        registration.addRecipes(recipes, VanillaRecipeCategoryUid.ANVIL);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(KilnScreen.class, 78, 32, 28, 23, new ResourceLocation[]{FiringRecipeCategory.UID, VanillaRecipeCategoryUid.FUEL});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(KilnContainer.class, FiringRecipeCategory.UID, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(KilnContainer.class, VanillaRecipeCategoryUid.FUEL, 1, 1, 3, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Kilns.KILN), new ResourceLocation[]{FiringRecipeCategory.UID, VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Woodcutters.WOODCUTTER), new ResourceLocation[]{WoodCuttingRecipeCategory.UID});
    }
}

